<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    
    include "../gUtil/GestoreUpload.php";
    include "../classi/TemplateCartelle.php";
    include "../classi/Cartella.php";
    
    include "include/controlloLogin.php";
    
    if(isset($_GET["id"])) {
        $templateCartelle = new TemplateCartelle($geecomDb, filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $templateCartelle->caricaDatiDalDatabase();
    }
    else {
        $templateCartelle = new TemplateCartelle($geecomDb, 0);
    }

    if(isset($templateCartelle) && $templateCartelle->getCartellaCollegata()!=0) {        
        $cartella = new Cartella($geecomDb, $templateCartelle->getCartellaCollegata());
        $cartella->caricaDatiDalDatabase();
    }

    $datiCartellaRadice = $geecomDb->leggiSingolaRiga("geecD_cartelleRadice",$_SESSION["geecomAdmin_id"],"idUtente");
    
    $cartellaRadice = new Cartella($geecomDb, $datiCartellaRadice["idCartella"]);
    $cartellaRadice->caricaDatiDalDatabase();
    
    $status = (isset($_GET["status"])) ? filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT) : 0;
?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
    <title>Geecom Doc - crea template cartelle <?= $templateCartelle->getNome() ?></title>

  </head>
  <body>
    
    <header>
        <?php 
            include "include/barraSuperiore.php";
            
            include "include/header.php";
            
            include "include/barraMenu.php";
        ?>
    </header>
      
    <main role="main" class="bg-light" id="main">
		<div class="container-fluid">
			<div class="row">
                            <!-- Colonna principale -->
                            <div class="col-12 py-4">
                                <?php 
                                    if($status==200) {
                                        echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                                Template creato
                                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                    <span aria-hidden=\"true\">&times;</span>
                                                </button>
                                            </div>";
                                    }
                                    else if($status==220) {
                                        echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                                Tempalte modificato
                                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                    <span aria-hidden=\"true\">&times;</span>
                                                </button>
                                            </div>";
                                    }
                                ?>
                                
                                <div class="card card-body border-0 mb-3">
                                    <form action="../controller/controllerTemplateCartelle.php" method="POST">
                                        <div class="row">
                                            <input type="text" class="d-none" name="operazione" value="<?= (isset($templateCartelle) && $templateCartelle->getId()>0) ? "modifica" : "crea" ?>">
                                            <input type="text" class="d-none" name="id" value="<?php echo(isset($templateCartelle) ? $templateCartelle->getId() : "0")?>">
                                            <div class="form-group col-lg-3">
                                                <label>Nome cartella:</label>
                                                <input type="text" class="form-control" id="nomeMenu" name="nome" aria-describedby="nome Menu" value="<?php echo(isset($templateCartelle) ? $templateCartelle->getNome() : "")?>" placeholder="Nome">
                                            </div>
                                            <div class="form-group col-lg-4">
                                                <label>Descrizione:</label>
                                                <input type="text" class="form-control" id="nomeMenu" name="descrizione" aria-describedby="nome Menu" value="<?php echo(isset($templateCartelle) ? $templateCartelle->getDescrizione() : "")?>" placeholder="Descrizione">
                                            </div>
                                            <?php 
                                                if($templateCartelle->getId()!=0) {
                                                    ?>
                                                    <div class="form-group col-lg-3">
                                                        <label>Cartella collegata:</label>
                                                        <select name="cartellaCollegata" class="form-control">
                                                            <option value="0">Seleziona</option>
                                                            <?php 
                                                                $query       = "SELECT * FROM geecD_cartelle WHERE cartellaMadre=2";
                                                                $risCartelle = $geecomDb->eseguiQueryLettura($query);
                                                                while($cartellaCollegata = $risCartelle->fetch_assoc()) {
                                                                    $selezionato = ($cartellaCollegata["id"]==$templateCartelle->getCartellaCollegata()) ? "selected" : "";
                                                                    echo"<option value=\"{$cartellaCollegata["id"]}\" $selezionato>{$cartellaCollegata["nome"]}</option>";
                                                                }
                                                            ?>
                                                        </select>
                                                    </div>
                                                    <?php
                                                }
                                            ?>
                                            <div class="col-lg-2 d-flex align-items-end text-right">
                                                <div class="form-group">
                                                    <a class="btn btn-outline-primary mt-2 mt-md-0" href="impostazioni.php?status=121"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                                    <button class="btn btn-primary mt-2 mt-md-0"><i class="fas fa-check"></i> Salva</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="form-row">
                                    <div class="col-md-4 col-lg-3 sticky-top-md align-self-start">
                                            <?php
                                                if(isset($cartella)) {
                                            ?>
                                                <form class="mb-3">
                                                    <div class="input-group">
                                                        <input type="text" class="d-none" id="campoInputCartellaMadre2" value="<?= $cartella->getId() ?>">
                                                        <input type="text" class="form-control" id="campoCreaCartella2" aria-label="Text input with segmented dropdown button">
                                                        <div class="input-group-append">
                                                            <button class="btn btn-primary" type="button" onclick="creaCartella('campoCreaCartella2','campoInputCartellaMadre2')"><span class="d-none d-xl-inline-block mr-2">Nuova cartella</span><i class="fas fa-folder-plus"></i></button>
                                                        </div>
                                                    </div>
                                                </form>
                                                <div class="card card-body border-0 mb-4 albero-cartelle" id="divAlberoCartella">
                                                    <?php
                                                        $cartellaRadice->alberoCartella(0,false);
                                                        $cartella->alberoCartellaTemplate(true,$cartella->getId());
                                                    ?>
                                                </div>
                                            <?php
                                                }
                                            ?>
                                    </div>
                                    <div class="col-md-8 col-lg-9 file-manager">
                                        <div class="card card-body border-0">
                                            <?php 
                                                if(isset($cartella)) {
                                                    ?>
                                                    <div class="d-lg-flex justify-content-between align-items-center mb-3">
                                                        <?php 
                                                            $cartella->stampaBreadcrumbCartella();
                                                        ?>
                                                        <div class="d-sm-flex align-items-center justify-content-between">
                                                            <form action="ricercaFileSystem.php" name="formRicerca">
                                                                <div class="input-group">
                                                                    <input type="text" class="form-control" name="cerca" id="cerca" placeholder="Cerca qualcosa..." aria-label="Text input with segmented dropdown button">
                                                                    <select class="form-control" name="tipoRicerca" id="tipoRicerca">
                                                                        <option value="Questa cartella">Questa cartella</option>
                                                                        <option value="Tutte le cartelle">Tutte le cartelle</option>
                                                                    </select>
                                                                    <div class="input-group-append">
                                                                        <button class="btn btn-primary" type="button" onclick="eseguiRicerca()"><i class="fas fa-search"></i></button>
                                                                    </div>
                                                                </div>
                                                            </form>

                                                            <div class="d-flex ml-2">
                                                                <div class="dropdown my-2 my-lg-0 mr-2">
                                                                    <a class="dropdown-toggle ml-lg-3" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                        <i class="fas fa-cog"></i>
                                                                    </a>

                                                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuLink">
                                                                        <a class="dropdown-item" href="#" onclick="apriPopupSpostaElementiSelezionati()"><i class="fas fa-arrow-right mr-2"></i>Sposta selezionati</a>
                                                                        <a class="dropdown-item text-danger" href="#" onclick="apriPopupEliminaElementiSelezionati()"><i class="far fa-trash-alt mr-2"></i>Elimina selezionati</a>
                                                                        <div class="dropdown-divider"></div>
                                                                        <a class="dropdown-item text-danger" href="#" data-toggle="modal" data-target="#modalEliminaContenutoCartella"><i class="far fa-trash-alt mr-2"></i>Elimina tutti</a>
                                                                    </div>
                                                                </div>

                                                                <div class="dropdown my-2 my-lg-0 ">
                                                                    <a class="dropdown-toggle ml-lg-3" href="#" role="button" id="dropdownOrderLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                        <i class="fas fa-sort"></i>
                                                                    </a>

                                                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownOrderLink">
                                                                        <a class="dropdown-item" href="#" onclick="apriPopupSpostaElementiSelezionati()"><i class="fas fa-sort-alpha-up mr-2"></i>A - Z</a>
                                                                        <a class="dropdown-item" href="#" onclick="apriPopupEliminaElementiSelezionati()"><i class="fas fa-sort-alpha-down mr-2"></i>Z - A</a>
                                                                        <a class="dropdown-item" href="#" onclick="apriPopupEliminaElementiSelezionati()"><i class="fas fa-history fa-flip-horizontal mr-2"></i>Più recenti</a>
                                                                        <a class="dropdown-item" href="#" onclick="apriPopupEliminaElementiSelezionati()"><i class="fas fa-history mr-2"></i>Meno recenti</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <form action="../controller/controllerDocumenti.php" id="frmFileUpload-00" class="dropzone singolo-file mb-3" method="post" enctype="multipart/form-data">
                                                        <div class="dz-message">
                                                            <i class="fas fa-file-upload fa-2x mb-2"></i>
                                                            <h5>Trascina o carica qui i file</h5>
                                                        </div>
                                                        <div class="fallback">
                                                            <input name="file" type="file" />
                                                        </div>
                                                    </form>

                                                    <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 row-cols-xl-4" id="divContenutoCartella">
                                                        <?php 
                                                            $cartella->stampaContenutoCartella(false);
                                                        ?>
                                                    </div>
                                                    <?php
                                                }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /Colonna principale -->
			</div>
		</div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/eliminaCartella.php";
        
        include "include/modal/eliminaElementiSelezionati.php";
        
        include "include/modal/eliminaContenutoCartella.php";
        
        include "include/modal/eliminaDocumento.php";
                
        include "include/modal/rinominaElemento.php";
        
        include "include/modal/spostaElemento.php";
        
        include "include/modal/spostaElementiSelezionati.php";
                
        include "include/modal/modalMenuComponenti.php";

        include "include/modal/modalCreaPaginaCondivisione.php";
                
        include "include/modal/modalCreaPaginaApprovazione.php";
        
        include "include/modal/operazioneCompletata.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>
        <script>
            function aggiornaContenutoCartella() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerCartelle.php",
                    data:{
                        operazione:"stampaContenutoCartella",
                        id:<?php echo $cartella->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("divContenutoCartella").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function aggiornaAlberoCartella() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerCartelle.php",
                    data:{
                        operazione:"stampaAlberoCartella",
                        id:<?php echo $cartella->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("divAlberoCartella").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
        </script>
      
        <script type="text/javascript" src="../plugins/dropzone/dropzone.js"></script>
        <script>
            $(".singolo-file").dropzone({
                acceptedFiles: ".pdf,.doc,.docx,.odt,.ppt,.pptx,.odp,.xls,.xlsx,.ods,.jpeg,.jpg,.png,.gif,.svg,.mp3,.mp4,.zip,.p7m",
                maxFiles: 10,
                parallelsuploads:10,
                uploadMultiple:true,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    if(response=="ok") {
                        aggiornaContenutoCartella();
                        this.removeAllFiles();
                    }
                    else {
                        alert(response);
                    }
                },
                params:{
                    operazione:"crea",
                    idCartella:<?php echo $cartella->getId() ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            });
        </script>
    </body>
</html>
